/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.engine;

import com.sinaflying.customise.R;
import com.sinaflying.engine.AvatarMould;
import com.sinaflying.engine.DependObject;
import com.sinaflying.engine.ResourceManager;
import com.sinaflying.engine.SptSet;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;

public class Avatar
extends DependObject {
    protected short _frmNum;
    protected short[] _sptNum;
    protected byte[][] _partId;
    protected short[][] _tileId;
    protected byte[][] _xoff;
    protected byte[][] _yoff;
    protected short _actNum;
    protected short[] _actFrmNum;
    protected short[][] _actFrmId;
    public byte[] _l;
    public byte[] _r;
    public byte[] _t;
    public byte[] _b;
    public byte[] _al;
    public byte[] _ar;
    public byte[] _at;
    public byte[] _ab;
    public short _vl;
    public short _vr;
    public short _vt;
    public short _vb;
    public boolean _isHaveCbox;
    public boolean _isHaveAbox;
    protected int _type;
    protected int _id;
    protected SptSet _sptSet;
    protected AvatarMould _mould;
    protected int[] _mouldParts;

    public short getActionNum() {
        return this._actNum;
    }

    public short getActFrmNum(int n) {
        return this._actFrmNum[n];
    }

    public void createAvatarRecord() {
        if (this.isAvatarType()) {
            int n = this._mould.getPartNum();
            this._mouldParts = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this._mouldParts[n2] = -1;
                ++n2;
            }
        }
    }

    public void setCurMouldPart(int n, int n2) {
        if (this._mouldParts == null) {
            return;
        }
        if (n < 0 || n >= this._mouldParts.length) {
            return;
        }
        this._mouldParts[n] = n2;
    }

    public final void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = n3 & Integer.MIN_VALUE;
        int n7 = n3 & 0x40000000;
        short s = this._actFrmId[n3 &= 0xFFFF][n4];
        int n8 = this._sptNum[s];
        try {
            boolean bl = this.isAvatarType();
            if (bl) {
                int n9 = 0;
                while (n9 < n8) {
                    int n10 = this._tileId[s][n9] & 0xFFFF;
                    byte by = this._partId[s][n9];
                    byte by2 = this._xoff[s][n9];
                    if (n6 != 0) {
                        by2 = -by2;
                    }
                    byte by3 = this._yoff[s][n9];
                    if (n7 != 0) {
                        by3 = -by3;
                    }
                    this._mould.draw(graphics, n + by2, n2 + by3, by, n10 | n6 | n7, n5, this._mouldParts[by]);
                    ++n9;
                }
            } else {
                int n11 = 0;
                while (n11 < n8) {
                    int n12 = this._tileId[s][n11] & 0xFFFF;
                    byte by = this._xoff[s][n11];
                    if (n6 != 0) {
                        by = -by;
                    }
                    byte by4 = this._yoff[s][n11];
                    if (n7 != 0) {
                        by4 = -by4;
                    }
                    this._sptSet.draw(graphics, n + by, n2 + by4, n12 | n6 | n7, n5, 4 | 0x10);
                    ++n11;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public final void drawClip(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n3 & Integer.MIN_VALUE;
        int n9 = n3 & 0x40000000;
        short s = this._actFrmId[n3 &= 0xFFFF][n4];
        int n10 = this._sptNum[s];
        try {
            boolean bl = this.isAvatarType();
            if (bl) {
                int n11 = 0;
                while (n11 < n10) {
                    int n12 = this._tileId[s][n11] & 0xFFFF;
                    byte by = this._partId[s][n11];
                    byte by2 = this._xoff[s][n11];
                    if (n8 != 0) {
                        by2 = -by2;
                    }
                    byte by3 = this._yoff[s][n11];
                    if (n9 != 0) {
                        by3 = -by3;
                    }
                    this._mould.draw(graphics, n + by2, n2 + by3, by, n12 | n8 | n9, n5, this._mouldParts[by]);
                    ++n11;
                }
            } else {
                int n13 = 0;
                while (n13 < n10) {
                    int n14 = this._tileId[s][n13] & 0xFFFF;
                    byte by = this._xoff[s][n13];
                    if (n8 != 0) {
                        by = -by;
                    }
                    byte by4 = this._yoff[s][n13];
                    if (n9 != 0) {
                        by4 = -by4;
                    }
                    this._sptSet.drawPart(graphics, n + by, n2 + by4, n14 | n8 | n9, n5, 4 | 0x10, n6, n7);
                    ++n13;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected boolean isAvatarType() {
        return this._type == 34;
    }

    protected void load(String string, int n) throws Exception {
        int n2;
        int n3;
        DataInputStream dataInputStream = R.openDataInputStream(string, -1);
        this.loadHeader(dataInputStream);
        this._type = dataInputStream.readByte();
        this._id = n;
        boolean bl = this.isAvatarType();
        this._frmNum = dataInputStream.readShort();
        this._sptNum = new short[this._frmNum];
        if (bl) {
            this._partId = new byte[this._frmNum][];
        }
        this._tileId = new short[this._frmNum][];
        this._xoff = new byte[this._frmNum][];
        this._yoff = new byte[this._frmNum][];
        int n4 = 0;
        while (n4 < this._frmNum) {
            this._sptNum[n4] = dataInputStream.readByte();
            if (bl) {
                this._partId[n4] = new byte[this._sptNum[n4]];
            }
            this._tileId[n4] = new short[this._sptNum[n4]];
            this._xoff[n4] = new byte[this._sptNum[n4]];
            this._yoff[n4] = new byte[this._sptNum[n4]];
            n3 = 0;
            while (n3 < this._sptNum[n4]) {
                if (bl) {
                    this._partId[n4][n3] = dataInputStream.readByte();
                }
                this._tileId[n4][n3] = dataInputStream.readShort();
                this._xoff[n4][n3] = dataInputStream.readByte();
                this._yoff[n4][n3] = dataInputStream.readByte();
                ++n3;
            }
            ++n4;
        }
        this._isHaveCbox = dataInputStream.readBoolean();
        this._isHaveAbox = dataInputStream.readBoolean();
        this._actNum = dataInputStream.readShort();
        if (this._isHaveCbox) {
            this._l = new byte[this._actNum];
            this._r = new byte[this._actNum];
            this._t = new byte[this._actNum];
            this._b = new byte[this._actNum];
        }
        if (this._isHaveAbox) {
            this._al = new byte[this._actNum];
            this._ar = new byte[this._actNum];
            this._at = new byte[this._actNum];
            this._ab = new byte[this._actNum];
        }
        this._actFrmNum = new short[this._actNum];
        this._actFrmId = new short[this._actNum][];
        n3 = 0;
        while (n3 < this._actNum) {
            if (this._isHaveCbox) {
                this._l[n3] = dataInputStream.readByte();
                this._r[n3] = dataInputStream.readByte();
                this._t[n3] = dataInputStream.readByte();
                this._b[n3] = dataInputStream.readByte();
            }
            if (this._isHaveAbox) {
                this._al[n3] = dataInputStream.readByte();
                this._ar[n3] = dataInputStream.readByte();
                this._at[n3] = dataInputStream.readByte();
                this._ab[n3] = dataInputStream.readByte();
            }
            this._actFrmNum[n3] = dataInputStream.readByte();
            this._actFrmId[n3] = new short[this._actFrmNum[n3]];
            n2 = 0;
            while (n2 < this._actFrmNum[n3]) {
                this._actFrmId[n3][n2] = dataInputStream.readShort();
                if (this._actFrmId[n3][n2] < 0) {
                    short[] sArray = this._actFrmId[n3];
                    int n5 = n2;
                    sArray[n5] = (short)(sArray[n5] + 256);
                }
                ++n2;
            }
            ++n3;
        }
        this._vl = dataInputStream.readShort();
        this._vr = dataInputStream.readShort();
        this._vt = dataInputStream.readShort();
        this._vb = dataInputStream.readShort();
        dataInputStream.close();
        dataInputStream = null;
        if (bl) {
            this._mould = new AvatarMould();
            this._mould.load("/res" + this._dependUrls[0]);
            this.createAvatarRecord();
            this.loadAvatarMould();
        } else {
            n2 = Integer.parseInt(this._dependUrls[0].substring(5, this._dependUrls[0].length() - 4));
            if (ResourceManager._spts[n2] == null) {
                this._sptSet = new SptSet();
                this._sptSet.load("/res" + this._dependUrls[0]);
                ResourceManager._spts[n2] = this._sptSet;
            } else {
                this._sptSet = ResourceManager._spts[n2];
            }
        }
    }

    protected void loadAvatarMould() {
        switch (this._id) {
            case 0: 
            case 1: 
            case 2: {
                this._mould.loadAvatarParts("/res/spt/part1-series0.xrs");
                this._mould.loadAvatarParts("/res/spt/part1-series1.xrs");
                this._mould.loadAvatarParts("/res/spt/part1-series2.xrs");
                this._mould.loadAvatarParts("/res/spt/part1-series3.xrs");
                this._mould.loadAvatarParts("/res/spt/part1-series4.xrs");
                this._mould.loadAvatarParts("/res/spt/part1-series5.xrs");
                this._mould.loadAvatarParts("/res/spt/part1-series6.xrs");
                this._mould.loadAvatarParts("/res/spt/part1-series7.xrs");
                this._mould.loadAvatarParts("/res/spt/part1-series8.xrs");
            }
        }
    }
}

